#!/bin/bash

#set path to mmap executable
prog=mmap

# ---------------------------------------------------------
# create binary genotype file 
genomxs=Z.bin
$prog --write_binary_genotype_file --binary_output_filename $genomxs --csv_input_filename Z.geno.T.csv  --num_skip_fields 1  
#exit
# not needed but show how mmap assigns missing chr,pos,effect_allele,etc
$prog --marker_by_subject_binary2csv --binary_input_filename $genomxs --csv_output_filename Z.geno.mmap.csv 
#exit

# ---------------------------------------------------------
# create binary relationship matrix
group=1000
pedigree=ped.csv
trait=id
id=id
binmat=pedigree.kinship.single.bin 
$dbg $prog --ped   $pedigree   --phenotype_filename  $pedigree --trait  $trait     --all_output --compute_binary_relationship_matrix_by_groups $binmat --group_size $group  --phenotype_id $id  --single_pedigree
# ---------------------------------------------------------

# phenotype 
phenotype=pheno.csv
trait=y
covariates=" sex bmi  "
snpinfo=snpinfo.tab

# ---------------------------------------------------------
# skat mixed model polygenic 
# treat pedigrees as single pedigee
suff=family.single
/usr/bin/time -v $prog  --read_snpinfo_file $snpinfo --binary_genotype_filename $genomxs --ped $pedigree --phenotype_filename $phenotype --trait $trait  --estimate_variance_components --variance_component_filename $binmat --num_em_reml_burnin 1 --use_em_ai_reml  --use_spotrs_dpotrs  --variance_component_label A --covariates $covariates --add_likelihood_constant  --score_test_weight  wu  --binary_covariate_filename $genomxs --file_suffix $suff  --num_mkl_threads 1  --single_pedigree
# pedigrees as independent 
suff=family.nuc
/usr/bin/time -v $prog  --read_snpinfo_file $snpinfo --binary_genotype_filename $genomxs --ped $pedigree --phenotype_filename $phenotype --trait $trait  --estimate_variance_components --variance_component_filename $binmat --num_em_reml_burnin 1 --use_em_ai_reml  --use_spotrs_dpotrs  --variance_component_label A --covariates $covariates --add_likelihood_constant  --score_test_weight  wu  --binary_covariate_filename $genomxs --file_suffix $suff  --num_mkl_threads 1  

# ---------------------------------------------------------
# skat linear model (no polygenic) 
suff=population
$prog  --read_snpinfo_file $snpinfo --binary_genotype_filename $genomxs --ped $pedigree --phenotype_filename $phenotype --trait $trait   --covariates $covariates --add_likelihood_constant  --score_test_weight  wu  --binary_covariate_filename $genomxs --file_suffix $suff --single_pedigree  --num_mkl_threads 1
exit


# ---------------------------------------------------------
# skat mixed model polygenic 
# subject set to analyze the first 250 pedigrees (2000 subjects)
# gene set to analyze gene88 and gene16 
suff=family.single.subject.gene
gene_set=gene.txt
subject_set=subjec.txt
/usr/bin/time -v $prog  --read_snpinfo_file $snpinfo --binary_genotype_filename $genomxs --ped $pedigree --phenotype_filename $phenotype --trait $trait  --estimate_variance_components --variance_component_filename $binmat --num_em_reml_burnin 1 --use_em_ai_reml  --use_spotrs_dpotrs  --variance_component_label A --covariates $covariates --add_likelihood_constant  --score_test_weight  wu  --binary_covariate_filename $genomxs --file_suffix $suff  --num_mkl_threads 1  --single_pedigree --gene_set $gene_set --subject_set $subject_set



# ---------------------------------------------------------
# skat mixed model polygenic 
# subject set to analyze the first 250 pedigrees (2000 subjects)
# gene set to analyze gene88 and gene16 
suff=family.single.subject.gene
gene_set=gene.txt
subject_set=subject.txt
/usr/bin/time -v $prog  --read_snpinfo_file $snpinfo --binary_genotype_filename $genomxs --ped $pedigree --phenotype_filename $phenotype --trait $trait  --estimate_variance_components --variance_component_filename $binmat --num_em_reml_burnin 1 --use_em_ai_reml  --use_spotrs_dpotrs  --variance_component_label A --covariates $covariates --add_likelihood_constant  --score_test_weight  wu  --binary_covariate_filename $genomxs --file_suffix $suff  --num_mkl_threads 1  --single_pedigree --gene_set $gene_set --subject_set $subject_set

exit

